%
% Generate Examples 9.2, 9.4 and 9.5 in Chapter 9 of the book:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in
% Making Subjective Judgments, Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 7/30/2009
%


clc
close all
clear all
warning off all

centroids=zeros(3,6);

%% word FOUs from IA
MFs=[0.0900    1.5000    3.0000    4.6200    1.7900    2.2800    2.2800    2.8100    0.4000
    0.0900    1.2500    2.5000    4.6200    1.6700    1.9200    1.9200    2.2100    0.3000
    3.5900    4.7500    5.5000    6.9100    4.8600    5.0300    5.0300    5.1400    0.2700
    5.9800    7.7500    8.6000    9.5200    8.0300    8.3600    8.3600    9.1700    0.5700
    7.3700    9.4100   10.0000   10.0000    8.7200    9.9100   10.0000   10.0000    1.0000
    5.3800    7.5000    8.7500    9.8100    7.7900    8.3000    8.3000    9.2100    0.5300];  % high

%% All 23 sub-criteria. The 4th column indicates whether this is a positive criterion
subs=[43 36 38 1
    25 20 23 -1
    .72 .8 .75 1
    80 83 76 1
    67 70 63 1
    84 88 86 1
    15^2 12^2 18^2 1 % end Tactics
    521*35^2*135	381*34^2*105	445*35^2*120 -1
    1.2	1.5	1.3 -1
    0.6	0.6	0.7 1
    68	75	70 1
    5 4 4 2% end Technology
    6 2 2 -2
    5 4 4 2
    4 5 4 2
    4 4 4 2
    4 4 1 2 % end Maintenace
    800	755	785 -1
    7	7	5 1
    6 2 2 -2 % end Economy
    3 4 3 2
    1 5 4 2
    4 4 5 2]; % end Advancement
groups=[0 7 12 17 20 23];

%% Case 1: crisp
subs2=subs;
for i=1:size(subs,1)
    if abs(subs(i,end))==1
        for j=1:size(subs,2)-1
            subs2(i,j)=subs(i,j)^subs(i,end);
        end
        subs2(i,1:3)=subs2(i,1:3)/max(subs2(i,1:3))*10; % map to a number in [0, 10]
    end
    for j=1:size(subs,2)-1
        if abs(subs(i,4))==1
            subFSs(i,9*(j-1)+1:9*j)=[subs2(i,j)*ones(1,8) 1];
        elseif subs(i,4)==2
            subFSs(i,9*(j-1)+1:9*j)=MFs(subs2(i,j),:);
        else %% complement
            subFSs(i,9*(j-1)+1:9*j)=[10-MFs(subs2(i,j),[4:-1:1 8:-1:5]) MFs(subs2(i,j),9)];
        end
    end
end

fuzzyNumbers=[1 1 1 2 1 1 1 2 1
    1 2 2 3 1 2 2 3 1
    2 3 3 4 2 3 3 4 1
    3 4 4 5 3 4 4 5 1
    4 5 5 6 4 5 5 6 1
    5 6 6 7 5 6 6 7 1
    6 7 7 8 6 7 7 8 1
    7 8 8 9 7 8 8 9 1
    8 9 9 9 8 9 9 9 1];

Ws=[7 1 9 9 9 7 6 4 9 9 8 9 5 6 2 3 3 8 8 5 5 7 3  9 3 1 5 7];

results1=zeros(6,27);
for i=1:5
    for j=1:3
        results1(i,9*(j-1)+1:9*j)=LWA(subFSs(groups(i)+1:groups(i+1),9*(j-1)+1:9*j),fuzzyNumbers(Ws(groups(i)+1:groups(i+1)),:));
    end
end
for j=1:3
    results1(6,9*(j-1)+1:9*j)=LWA(results1(1:5,9*(j-1)+[1:9]),fuzzyNumbers(Ws(end-4:end),:));
end

numbers='abcdefgh';
for i=1:6
    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',12);
    set(gcf,'DefaultaxesFontSize',10);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(3,1.4,1);
    hold on
    for j=1:3
        switch j
            case 1
                plot(results1(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results1(i,[9*j 9*j]) 0],'k','linewidth',1.5);
                plot(centroidIT2(results1(i,9*(j-1)+[1:9])),0,'k*');
            case 2
                plot(results1(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results1(i,[9*j 9*j]) 0],'--k','linewidth',1.5);
                plot(centroidIT2(results1(i,9*(j-1)+[1:9])),0,'kd');
            case 3
                plot(results1(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results1(i,[9*j 9*j]) 0],':k','linewidth',1.5);
                plot(centroidIT2(results1(i,9*(j-1)+[1:9])),0,'ko');
        end
    end
    switch i
        case 1
            text('Interpreter','latex','String','$$\widetilde{Y}_{B1}$$','Position',[8.1, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{A1}$$','Position',[8.8, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C1}$$','Position',[9.5, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_1=\tilde{9}}$$','Position',[.5, .2]);
        case 2
            text('Interpreter','latex','String','$$\widetilde{Y}_{B2}$$','Position',[7.9, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{A2}$$','Position',[8.6, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C2}$$','Position',[9.3, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_2=\tilde{3}}$$','Position',[.5, .2]);
        case 3
            text('Interpreter','latex','String','$$\widetilde{Y}_{A3}$$','Position',[mean(results1(i,9*(1-1)+[2 3]))-.5, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B3}$$','Position',[mean(results1(i,9*(2-1)+[2 3]))-.25, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C3}$$','Position',[mean(results1(i,9*(3-1)+[2 3])), 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_3=\tilde{1}}$$','Position',[.5, .2]);
        case 4
            text('Interpreter','latex','String','$$\widetilde{Y}_{A4}$$','Position',[mean(results1(i,9*(1-1)+[2 3]))-.5, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B4}$$','Position',[mean(results1(i,9*(2-1)+[2 3]))-.25, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C4}$$','Position',[mean(results1(i,9*(3-1)+[2 3]))-.25, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_4=\tilde{5}}$$','Position',[.5, .2]);
        case 5
            text('Interpreter','latex','String','$$\widetilde{Y}_{A5}$$','Position',[mean(results1(i,9*(1-1)+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B5}$$','Position',[mean(results1(i,9*(2-1)+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C5}$$','Position',[mean(results1(i,9*(3-1)+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_5=\tilde{7}}$$','Position',[.5, .2]);
        case 6
            text('Interpreter','latex','String','$$\widetilde{Y}_A$$','Position',[mean(results1(i,9*(1-1)+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_B$$','Position',[mean(results1(i,9*(2-1)+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_C$$','Position',[mean(results1(i,9*(3-1)+[2 3]))-.3, 1.2]);
            for j=1:3
                [temp,centroids(j,1), centroids(j,2)]=centroidIT2(results1(i,9*(j-1)+[1:9]));
            end
    end
    axis([0 10.5 0 1.4]);
    set(gca,'YTick',[0:0.5:1]);
    set(gca,'XTick',[0:1:10]);
    box off
    text(10.7,0.03,'y');
    text(0.2,1.28,'u');
    arrow([0,0],[10.5,0],0.06,pi/10,0.5,[0 0 0],'-');
    arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
    saveas(gcf,['Fig9-4' numbers(i) '.eps']);
end

%% Case 2: IT2 FS, unctn=0.1
unctn1=.1;
for i=1:size(subs,1)
    if subs(i,end)==1
        for j=1:size(subs,2)-1
            temp2(i,2*j-1:2*j)=[subs(i,j)*(1-unctn1) min(max(subs(i,:)),subs(i,j)*(1+unctn1))];
        end
        temp2(i,:)=temp2(i,:)/max(temp2(i,:))*10; % map to a number in [0, 10]
    elseif subs(i,end)==-1
        for j=1:size(subs,2)-1
            temp2(i,2*j-1:2*j)=[1/max(min(subs(i,:)),subs(i,j)*(1+unctn1)) 1/(subs(i,j)*(1-unctn1))];
        end
        temp2(i,:)=temp2(i,:)/max(temp2(i,:))*10; % map to a number in [0, 10]
    end

    for j=1:size(subs,2)-1
        if i==8
            subFSs(i,9*(j-1)+1:9*j) =[subs2(i,j)*ones(1,8) 1]; % no uncertainty
        else
            if abs(subs(i,4))==1
                subFSs(i,9*(j-1)+1:9*j)=[temp2(i,2*j-1)*[1 1] temp2(i,2*j)*[1 1] temp2(i,2*j-1)*[1 1] temp2(i,2*j)*[1 1] 1];
            elseif subs(i,4)==2
                subFSs(i,9*(j-1)+1:9*j)=MFs(subs2(i,j),:);
            else %% complement
                subFSs(i,9*(j-1)+1:9*j)=[10-MFs(subs2(i,j),[4:-1:1 8:-1:5]) MFs(subs2(i,j),9)];
            end
        end
    end
end

results2=zeros(6,27);
for i=1:5
    for j=1:3
        results2(i,9*(j-1)+1:9*j)=LWA(subFSs(groups(i)+1:groups(i+1),9*(j-1)+1:9*j),fuzzyNumbers(Ws(groups(i)+1:groups(i+1)),:));
    end
end
for j=1:3
    results2(6,9*(j-1)+1:9*j)=LWA(results2(1:5,9*(j-1)+[1:9]),fuzzyNumbers(Ws(end-4:end),:));
end

for i=1:6
    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',12);
    set(gcf,'DefaultaxesFontSize',10);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(3,1.4,1);
    hold on
    for j=1:3
        switch j
            case 1
                plot(results2(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results2(i,[9*j 9*j]) 0],'k','linewidth',1.5);
                plot(centroidIT2(results2(i,9*(j-1)+[1:9])),0,'k*');
            case 2
                plot(results2(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results2(i,[9*j 9*j]) 0],'--k','linewidth',1.5);
                plot(centroidIT2(results2(i,9*(j-1)+[1:9])),0,'kd');
            case 3
                plot(results2(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results2(i,[9*j 9*j]) 0],':k','linewidth',1.5);
                plot(centroidIT2(results2(i,9*(j-1)+[1:9])),0,'ko');
        end
    end
    switch i
        case 1
            text('Interpreter','latex','String','$$\widetilde{Y}_{B1}$$','Position',[8, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{A1}$$','Position',[8.7, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C1}$$','Position',[9.4, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_1=\tilde{9}}$$','Position',[.5, .2]);
        case 2
            text('Interpreter','latex','String','$$\widetilde{Y}_{B2}$$','Position',[7.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{A2}$$','Position',[8, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C2}$$','Position',[8.7, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_2=\tilde{3}}$$','Position',[.5, .2]);
        case 3
            text('Interpreter','latex','String','$$\widetilde{Y}_{A3}$$','Position',[mean(results2(i,[2 3]))-.4, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B3}$$','Position',[mean(results2(i,9+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C3}$$','Position',[mean(results2(i,18+[2 3])), 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_3=\tilde{1}}$$','Position',[.5, .2]);
        case 4
            text('Interpreter','latex','String','$$\widetilde{Y}_{A4}$$','Position',[mean(results2(i,[2 3]))-.4, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B4}$$','Position',[mean(results2(i,9+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C4}$$','Position',[mean(results2(i,18+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_4=\tilde{5}}$$','Position',[.5, .2]);
        case 5
            text('Interpreter','latex','String','$$\widetilde{Y}_{A5}$$','Position',[mean(results2(i,[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B5}$$','Position',[mean(results2(i,9+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C5}$$','Position',[mean(results2(i,18+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_5=\tilde{7}}$$','Position',[.5, .2]);
        case 6
            text('Interpreter','latex','String','$$\widetilde{Y}_A$$','Position',[mean(results2(i,[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_B$$','Position',[mean(results2(i,9+[2 3]))-.1, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_C$$','Position',[mean(results2(i,18+[2 3]))-.3, 1.2]);
            for j=1:3
                [temp,centroids(j,3), centroids(j,4)]=centroidIT2(results2(i,9*(j-1)+[1:9]));
            end
    end
    axis([0 10.5 0 1.4]);
    set(gca,'YTick',[0:0.5:1]);
    set(gca,'XTick',[0:1:10]);
    box off
    text(10.7,0.03,'y');
    text(0.2,1.28,'u');
    arrow([0,0],[10.5,0],0.06,pi/10,0.5,[0 0 0],'-');
    arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
    saveas(gcf,['Fig9-5' numbers(i) '.eps']);
end

%% Case 3: Interval
unctns=[.1 .20 .05];
for i=1:size(subs,1)
    if subs(i,end)==1
        for j=1:size(subs,2)-1
            temp2(i,2*j-1:2*j)=[subs(i,j)*(1-unctns(j)) min(max(subs(i,:)),subs(i,j)*(1+unctns(j)))];
        end
        temp2(i,:)=temp2(i,:)/max(temp2(i,:))*10; % map to a number in [0, 10]
    elseif subs(i,end)==-1
        for j=1:size(subs,2)-1
            temp2(i,2*j-1:2*j)=[1/max(min(subs(i,:)),subs(i,j)*(1+unctns(j))) 1/(subs(i,j)*(1-unctns(j)))];
        end
        temp2(i,:)=temp2(i,:)/max(temp2(i,:))*10; % map to a number in [0, 10]
    end

    for j=1:size(subs,2)-1
        if i==8
            subFSs(i,9*(j-1)+1:9*j) =[subs2(i,j)*ones(1,8) 1]; % no uncertainty
        else
            if abs(subs(i,4))==1
                subFSs(i,9*(j-1)+1:9*j)=[temp2(i,2*j-1)*[1 1] temp2(i,2*j)*[1 1] temp2(i,2*j-1)*[1 1] temp2(i,2*j)*[1 1] 1];
            elseif subs(i,4)==2
                subFSs(i,9*(j-1)+1:9*j)=MFs(subs2(i,j),:);
            else %% complement
                subFSs(i,9*(j-1)+1:9*j)=[10-MFs(subs2(i,j),[4:-1:1 8:-1:5]) MFs(subs2(i,j),9)];
            end
        end
    end
end

results3=zeros(6,27);
for i=1:5
    for j=1:3
        results3(i,9*(j-1)+1:9*j)=LWA(subFSs(groups(i)+1:groups(i+1),9*(j-1)+1:9*j),fuzzyNumbers(Ws(groups(i)+1:groups(i+1)),:));
    end
end
for j=1:3
    results3(6,9*(j-1)+1:9*j)=LWA(results3(1:5,9*(j-1)+[1:9]),fuzzyNumbers(Ws(end-4:end),:));
end

numbers='abcdef';
for i=1:6
    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',12);
    set(gcf,'DefaultaxesFontSize',10);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(3,1.4,1);
    hold on
    for j=1:3
        switch j
            case 1
                plot(results3(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results3(i,[9*j 9*j]) 0],'k','linewidth',1.5);
                plot(centroidIT2(results3(i,9*(j-1)+[1:9])),0,'k*');
            case 2
                plot(results3(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results3(i,[9*j 9*j]) 0],'--k','linewidth',1.5);
                plot(centroidIT2(results3(i,9*(j-1)+[1:9])),0,'kd');
            case 3
                plot(results3(i,9*(j-1)+[1:4 8:-1:5]),[0 1 1 0 0 results3(i,[9*j 9*j]) 0],':k','linewidth',1.5);
                plot(centroidIT2(results3(i,9*(j-1)+[1:9])),0,'ko');
        end
    end
    switch i
        case 1
            text('Interpreter','latex','String','$$\widetilde{Y}_{B1}$$','Position',[7, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{A1}$$','Position',[7.7, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C1}$$','Position',[8.4, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_1=\tilde{9}}$$','Position',[.5, .2]);
        case 2
            text('Interpreter','latex','String','$$\widetilde{Y}_{B2}$$','Position',[7.2, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{A2}$$','Position',[7.9, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C2}$$','Position',[8.6, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_2=\tilde{3}}$$','Position',[.5, .2]);
        case 3
            text('Interpreter','latex','String','$$\widetilde{Y}_{A3}$$','Position',[mean(results3(i,[2 3]))-.5, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B3}$$','Position',[mean(results3(i,9+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C3}$$','Position',[mean(results3(i,18+[2 3])), 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_3=\tilde{1}}$$','Position',[.5, .2]);
        case 4
            text('Interpreter','latex','String','$$\widetilde{Y}_{A4}$$','Position',[mean(results3(i,[2 3]))-.5, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B4}$$','Position',[mean(results3(i,9+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C4}$$','Position',[mean(results3(i,18+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_4=\tilde{5}}$$','Position',[.5, .2]);
        case 5
            text('Interpreter','latex','String','$$\widetilde{Y}_{A5}$$','Position',[mean(results3(i,[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{B5}$$','Position',[mean(results3(i,9+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_{C5}$$','Position',[mean(results3(i,18+[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\mathbf{\widetilde{W}_5=\tilde{7}}$$','Position',[.5, .2]);
        case 6
            text('Interpreter','latex','String','$$\widetilde{Y}_A$$','Position',[mean(results3(i,[2 3]))-.3, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_B$$','Position',[mean(results3(i,9+[2 3]))+.1, 1.2]);
            text('Interpreter','latex','String','$$\widetilde{Y}_C$$','Position',[mean(results3(i,18+[2 3]))-.3, 1.2]);
            for j=1:3
                [temp,centroids(j,5), centroids(j,6)]=centroidIT2(results3(i,9*(j-1)+[1:9]));
            end
    end
    axis([0 10.5 0 1.4]);
    set(gca,'YTick',[0:0.5:1]);
    set(gca,'XTick',[0:1:10]);
    box off
    text(10.7,0.03,'y');
    text(0.2,1.28,'u');
    arrow([0,0],[10.5,0],0.06,pi/10,0.5,[0 0 0],'-');
    arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
    saveas(gcf,['Fig9-6' numbers(i) '.eps']);
end

%%
format bank
centroids
c=[mean(centroids(:,1:2),2) mean(centroids(:,3:4),2) mean(centroids(:,5:6),2)]
r=[diff(centroids(:,1:2)',1,1)'/2 diff(centroids(:,3:4)',1,1)'/2 diff(centroids(:,5:6)',1,1)'/2]

for i=1:3
    for j=1:3
        sim1(i,j)=Jaccard(results1(6,9*(i-1)+[1:9]),results1(6,9*(j-1)+[1:9]));
        sim2(i,j)=Jaccard(results2(6,9*(i-1)+[1:9]),results2(6,9*(j-1)+[1:9]));
        sim3(i,j)=Jaccard(results3(6,9*(i-1)+[1:9]),results3(6,9*(j-1)+[1:9]));
    end
end

sim1
sim2
sim3

close all
